﻿//////////////////////////////////////////////
// GamepadDeviceManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class System ;
}

/// Includes ---------------------------------

// nkInputs
#include "../../Dll/DllDefines.h"

#include "GamepadDevice.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <unordered_map>
#include <string>

/// Class ------------------------------------

namespace nkInputs
{
	class DLL_INPUTS_EXPORT GamepadDeviceManager final : public nkCommon::MaybeSingletonClass<GamepadDeviceManager>
	{
		public :

			// Getters
			System* getSystem () const ;

			// Memory management
			GamepadDevice* createOrRetrieve (nkMemory::StringView name) ;
			GamepadDevice* record (nkMemory::StringView name, nkMemory::UniquePtr<GamepadDevice> device) ;
			GamepadDevice* get (nkMemory::StringView name) const ;
			GamepadDevice* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<GamepadDevice> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor
			GamepadDeviceManager (bool isSingleton) noexcept ;
			GamepadDeviceManager (System* system) noexcept ;
			GamepadDeviceManager (const GamepadDeviceManager&) = delete ;

			// Operators
			GamepadDeviceManager& operator= (const GamepadDeviceManager&) = delete ;

		private :

			// Attributes
			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<GamepadDevice>> _devices ;
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<GamepadDeviceManager> ;
			friend class System ;
	} ;
}